#ifndef __IMAGEOP_H__
#define __IMAGEOP_H__

#ifdef __cplusplus

void Convert2Gray(Image *pI);

Image Threshold(const Image *pImg, unsigned ThrValue);

Image Mask(Image *im_in, int size);
Image Median(const Image &im_in, int size);


Image Peel8bit(const Image Img, int PlaneNum8);
Image PeelPlane(const Image Img, int PlaneNum);

void PeelPlane(Raster2DAbstract & obr, Raster2DAbstract & PlaneX, int PlaneNum);
void JoinPlane(const Raster2DAbstract & PlaneX, Raster2DAbstract & Obr, uint8_t PlaneNum);


typedef enum
{
	gfGaus     = 0,
	gfGausDiffX= 1,
	gfGausDiffY= 2,
	gfGausDiff = 3,
	gfCanny    = 4,
	gfCannyFast= 5,
	gfGausLap  = 6
} EGaussOp;

void GausFunc(Raster2DAbstract *obr, unsigned char FuncC, unsigned char GausN);

#endif

#endif // __IMAGEOP_H__ 